﻿DROP VIEW v_pdv_vd_cred;

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 202202232251
'Job.................:  
'Nome................: v_pdv_vd_cred 
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 04/02/2022
'Criado por..........: Eduardo Costa Moraes
'Dt Ult Alteracão....: 18/03/2022
'Alterado por........: Marcos Barros

'=======================================================================================
-- FARMAGOI-28347 - Venda Crediário duplicando parcelas e valor da venda -f.tipo_transacao =3

*/

CREATE OR REPLACE VIEW public.v_pdv_vd_cred
 AS
 SELECT a.cd_emp,
    a.cd_filial,
    a.cd_vd,
    a.cd_cx,
    a.cd_cli,
    a.nr_ecf,
    a.dt_vd,
    a.vlr_cartao,
    b.cd_parc,
    b.dt_parc,
    b.vl_parc,
    a.qt_parc_cred,
    b.nr_fatura,
    a.cd_usu,
    COALESCE(a.flag_consolidado, 0) AS flag_consolidado,
    a.st_vd,
    ( SELECT
                CASE a.st_vd
                    WHEN 0 THEN 0
                    WHEN 1 THEN 2
                    ELSE NULL::integer
                END AS "case") AS sts_lanc_cred,
    a.nm_comprador,
    d.cd_mdl_vd,
    d.rz_cli,
    d.cgc_cpf,
    f.qt_parc,
    COALESCE(e.ds_mdl_vd, ''::character varying, e.ds_mdl_vd) AS ds_mdl_vd
   FROM pdv_vd a
     JOIN pdv_vd_cred b ON a.cd_emp = b.cd_emp AND a.cd_filial = b.cd_filial AND a.cd_vd = b.cd_vd
     JOIN rc_cli_crediario d ON d.cd_cli = a.cd_cli
     JOIN rc_mdl_venda e ON d.cd_mdl_vd = e.cd_mdl_vd
     JOIN pdv_vd_tef f ON a.cd_emp = f.cd_emp AND a.cd_filial = f.cd_filial AND a.cd_vd = f.cd_vd AND f.tipo_transacao =3
  ORDER BY b.cd_parc;

ALTER TABLE public.v_pdv_vd_cred
    OWNER TO postgres;
